<?php
/**
 * Functions
 *
 * @package     AutomatorWP\Integrations\WooCommerce\Functions
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly
if( !defined( 'ABSPATH' ) ) exit;

/**
 * Helper function to get the address fields
 *
 * @since 1.0.0
 *
 * @return array
 */
function automatorwp_woocommerce_get_address_fields() {

    return array(
        'first_name',
        'last_name',
        'company',
        'address_1',
        'address_2',
        'city',
        'postcode',
        'country',
        'state',
        'phone',
        'email',
    );

}

/**
 * Helper function to get an address field label
 *
 * @since 1.0.0
 *
 * @param string $field
 *
 * @return string
 */
function automatorwp_woocommerce_get_address_field_label( $field ) {

    $labels = array(
        'first_name' => __( 'First name', 'automatorwp-pro' ),
        'last_name' => __( 'Last name', 'automatorwp-pro' ),
        'company' => __( 'Company', 'automatorwp-pro' ),
        'address_1' => __( 'Address line 1', 'automatorwp-pro' ),
        'address_2' => __( 'Address line 2', 'automatorwp-pro' ),
        'city' => __( 'City', 'automatorwp-pro' ),
        'postcode' => __( 'Postcode / ZIP', 'automatorwp-pro' ),
        'country' => __( 'Country / Region', 'automatorwp-pro' ),
        'state' => __( 'State / County', 'automatorwp-pro' ),
        'phone' => __( 'Phone', 'automatorwp-pro' ),
        'email' => __( 'Email', 'automatorwp-pro' ),
    );

    return isset( $labels[$field] ) ? $labels[$field] : '';

}

/**
 * Helper function to get an address field preview
 *
 * @since 1.0.0
 *
 * @param string $field
 *
 * @return string
 */
function automatorwp_woocommerce_get_address_field_preview( $field ) {

    $previews = array(
        'first_name' => __( 'AutomatorWP', 'automatorwp-pro' ),
        'last_name' => __( 'Plugin', 'automatorwp-pro' ),
        'company' => __( 'AutomatorWP Ltd.', 'automatorwp-pro' ),
        'address_1' => __( 'False Street, 123', 'automatorwp-pro' ),
        'address_2' => __( 'First floor, door 2', 'automatorwp-pro' ),
        'city' => __( 'Brooklyn', 'automatorwp-pro' ),
        'postcode' => __( '12345', 'automatorwp-pro' ),
        'country' => __( 'United States', 'automatorwp-pro' ),
        'state' => __( 'New York', 'automatorwp-pro' ),
        'phone' => __( '202-555-1234', 'automatorwp-pro' ),
        'email' => __( 'contact@automatorwp.com', 'automatorwp-pro' ),
    );

    return isset( $previews[$field] ) ? $previews[$field] : '';

}

/**
 * Helper function to compare order statuses
 *
 * @since 1.0.0
 *
 * @param string $status
 * @param string $required_status
 *
 * @return string
 */
function automatorwp_woocommerce_order_status_matches( $status, $required_status ) {

    $status = 'wc-' === substr( $status, 0, 3 ) ? substr( $status, 3 ) : $status;
    $required_status = 'wc-' === substr( $required_status, 0, 3 ) ? substr( $required_status, 3 ) : $required_status;

    // Bail if status doesn't match with the trigger option
    if( $required_status !== 'any' && $status !== $required_status ) {
        return false;
    }

    return true;

}

/**
 * Options callback for select2 fields assigned to variations
 *
 * @since 1.0.0
 *
 * @param stdClass $field
 *
 * @return array
 */
function automatorwp_woocommerce_options_cb_variations( $field ) {

    // Setup vars
    $value = $field->escaped_value;
    $none_value = 'any';
    $none_label = __( 'any variation', 'automatorwp' );
    $options = automatorwp_options_cb_none_option( $field, $none_value, $none_label );

    if( ! empty( $value ) ) {
        if( ! is_array( $value ) ) {
            $value = array( $value );
        }

        foreach( $value as $variation_id ) {

            // Skip option none
            if( $variation_id === $none_value ) {
                continue;
            }

            $options[$variation_id] = automatorwp_woocommerce_get_variation_title( $variation_id );
        }
    }

    return $options;

}

/**
 * Get the variation title
 *
 * @since 1.0.0
 *
 * @param int $variation_id
 *
 * @return string|null
 */
function automatorwp_woocommerce_get_variation_title( $variation_id ) {

    // Empty title if no ID provided
    if( absint( $variation_id ) === 0 ) {
        return '';
    }

    $variation = wc_get_product( $variation_id );
    
    $attributes = $variation->get_attributes();

    return implode( ', ', array_values( $attributes ) );

}